//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

#include "toitoiles.glsl"

vec3 polar(vec3 cart)
{
    vec3 p= vec3(0.0);
    p.x = length(cart);
    p.y = acos(cart.y / p.x);
    p.z = atan(cart.z, cart.x);
    return p;
}


vec3 getLunarCoord(vec3 pos)
{
    vec3 npos = normalize(pos);

    npos = normalize(moonRotMatrix * npos);
    return npos;
}

vec3 DrawShiningStar(vec3 color, vec3 wpos, vec3 starPos, float dither)
{
	vec3 clr = color;
    vec3 polwpos = polar(wpos);
    vec3 polspos = polar(starPos);

    vec3 poldiff = polwpos-polspos;

    vec3 diff = starPos-wpos;

	#ifdef SHININGSTARS_JITTER

	float jitterSpeed = mix(3.0,9.0,abs(starPos.x+starPos.z)/2.0);
	float starJitter = sin(frameTimeCounter * jitterSpeed * SHININGSTARS_JITTER_SPEED) * 0.5 + 1.0;

	#else

	float starJitter = 1.0;

	#endif

	#ifdef SHININGSTARS_AA
	#if AA>1
	dither=fract(64.*frameTimeCounter+dither);
	#endif
	#else
	dither=1.0;
	#endif

	float s0 = max((0.007 * SIZESTARS) - length(diff),0.0)*100.0;
    float s1 = max(THICKSTARS - abs(poldiff.z),0.0)*100.0;
    float s2 = max(THICKSTARS - abs(poldiff.y),0.0)*100.0;
    float s  = max(s1,s2)*s0*SHININGSTARS_INTENSITY*starJitter*dither;

    float s0d = max((0.004 * SIZESTARS) - length(diff),0.0)*100.0;
    float s1d = max(THICKSTARS - abs(poldiff.z-poldiff.y),0.0)*100.0;
    float s2d = max(THICKSTARS - abs(poldiff.z+poldiff.y),0.0)*100.0;
    float sd  = max(s1d,s2d)*s0d*SHININGSTARS_INTENSITY*starJitter*dither;

    clr = max(vec3(max(s,sd)),clr);
    return clr;
};

void DrawMoonCircle(inout vec3 color, in vec3 wpos)
{
    vec3 circlePos = vec3(0.0,1.0,0.0);
   

    vec3 polwpos = polar(wpos);
    vec3 polspos = polar(circlePos);

    vec3 poldiff = polwpos-polspos;

    vec3 diff = circlePos-wpos;

    if(length(diff)> 0.1 && length(diff)<0.11)
    color = vec3(1.0,0.0,0.0);
};


vec3 DrawLine(vec3 color,vec3 v1,vec3 v2,vec3 wpos)
{
    vec3 clr = color;
    float l1=length(v1-wpos);
    float l2=length(v2-wpos);
    float l3=length(v1-v2);
    if (l3<LINE_THICKNESS)l3 = LINE_THICKNESS;
    float l4=length(((v1+v2)/2.0) - wpos);

    vec3 ss3 = cross(v1,v2);
    ss3 = normalize(ss3);
    float dist = dot(wpos,ss3);
    
    if (dist < 0 ) dist = -dist;
    if ((dist < LINE_THICKNESS && l3>l1  && l3>l2))
    {
        clr = mix(clr,vec3(0.2,0.2,0.3),LINE_TRANSPARENCY);
    }
    return clr;
};

ivec2 getConstell(vec3 viewPos)
{
    int minindex1 = 0;
	int minindex2 = 0;
    float minl1 = length(viewPos - centers[0]);
	float minl2 = length(viewPos - centers[0]);
    for(int i = 1;i<numconstell;i++)
    {
        float l = length(viewPos - centers[i]);
        if(l < minl1)
        {
			minl2 = minl1;
            minl1 = l;
			minindex2 = minindex1;
            minindex1 = i;
        }
		else if (l < minl2)
		{
			minl2 = l;
			minindex2 = i;
		}
    }
	ivec2 indexes = ivec2(minindex1,-1);
	if(minl2-minl1 < 0.02)
	{
		indexes.y = minindex2;
	}
    return indexes;
}